<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('position')->nullable();
            $table->string('type')->nullable();
            $table->text('short_description')->nullable();
            $table->text('description')->nullable();
            $table->string('link')->nullable();
            $table->integer('parent_id')->nullable();
            $table->string('banner')->nullable();
            $table->string('display_type')->nullable();
            $table->string('icon')->nullable();
            $table->string('weight')->nullable();
            $table->boolean('status')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('meta_title')->nullable();
            $table->string('meta_keyword')->nullable();
            $table->string('slug')->nullable(); 
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pages');
    }
}
